' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com. 
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Imports Microsoft.VisualBasic

''' <summary>
''' Klasa Content reprezentuje jednostk treci w bazie danych, ktra moe by wywietlona na stronie.
''' </summary>
Public Class Content

#Region "Zmienne prywatne"

  Private _id As Integer
  Private _title As String
  Private _introText As String
  Private _bodyText As String
  Private _contentTypeId As Integer
  Private _categoryId As Integer
  Private _visible As Boolean

#End Region

#Region "Konstruktory"

  ''' <summary>
  ''' Konstruktor domylny klasy Content. Uywany do tworzenia zuepnie nowej jednostki treci.
  ''' </summary>
  Public Sub New()

  End Sub

  ''' <summary>
  ''' Przeadowany konstruktor klasy Content, ktry przyjmuje identyfikator istniejcej jednostki treci, ktry jest zachowywany w prywatnym polu _id.
  ''' </summary>
  Public Sub New(ByVal id As Integer)
    _id = id
  End Sub

#End Region

#Region "Waciwoci publiczne"

  ''' <summary>
  ''' Identyfikator jednostki treci w bazie danych. 
  ''' </summary>
  ''' <remarks>Ta waciwo jest tylko do odczytu, aby uniemoliwi jej zmian w czasie istnienia obiektu. Uyj przeadomanej wersji konstruktora, aby ustawi Id istniejcych jednostek treci.</remarks>
  Public ReadOnly Property Id() As Integer
    Get
      Return _id
    End Get
  End Property

  ''' <summary>
  ''' Tyru jednostki treci.
  ''' </summary>
  Public Property Title() As String
    Get
      Return _title
    End Get
    Set(ByVal value As String)
      _title = value
    End Set
  End Property

  ''' <summary>
  ''' Wstp dla jednostki treci, zawierajcy jej pierwszy akapit.
  ''' </summary>
  Public Property IntroText() As String
    Get
      Return _introText
    End Get
    Set(ByVal value As String)
      _introText = value
    End Set
  End Property

  ''' <summary>
  ''' Cay tekst jednostki treci.
  ''' </summary>
  Public Property BodyText() As String
    Get
      Return _bodyText
    End Get
    Set(ByVal value As String)
      _bodyText = value
    End Set
  End Property

  ''' <summary>
  ''' Identyfikator typu treci, do ktrego nalezy jednostka treci.
  ''' </summary>
  Public Property ContentTypeId() As Integer
    Get
      Return _contentTypeId
    End Get
    Set(ByVal value As Integer)
      _contentTypeId = value
    End Set
  End Property

  ''' <summary>
  ''' Identyfikator kategorii, do ktrej nalezy jednostka treci.
  ''' </summary>
  Public Property CategoryId() As Integer
    Get
      Return _categoryId
    End Get
    Set(ByVal value As Integer)
      _categoryId = value
    End Set
  End Property

  ''' <summary>
  ''' Okrela, czy jednostka treci jest widoczna w publicznej czci witryny.
  ''' </summary>
  Public Property Visible() As Boolean
    Get
      Return _visible
    End Get
    Set(ByVal value As Boolean)
      _visible = value
    End Set
  End Property

#End Region

#Region "Metody publiczne"

  ''' <summary>
  ''' Zapisuje jednostk treci w bazie danych.
  ''' </summary>
  Public Sub Save()
    ContentDB.Save(Me)
  End Sub

  ''' <summary>
  ''' Pobiera z bazy danych jednostk w oparciu o jej identyfikator.
  ''' </summary>
  Public Shared Function GetItem(ByVal id As Integer) As Content
    Return ContentDB.GetItem(id)
  End Function

#End Region

End Class
